<?php
if (defined('VBBLOG_CACHED_TEMPLATES'))
{
	// Workaround because they use get_class -.-
	if (
		$this->registry->options['vbblog_blogthispost']
			AND
		$this->registry->userinfo['permissions']['vbblog_general_permissions'] & $this->registry->bf_ugp_vbblog_general_permissions['blog_canviewown']
			AND
		$this->registry->userinfo['permissions']['vbblog_entry_permissions'] & $this->registry->bf_ugp_vbblog_entry_permissions['blog_canpost']
			AND
		$this->registry->userinfo['userid']
	)
	{
		$templater = vB_Template::create('blog_postbit_blog_this_post');
			$templater->register('post', $post);
		$template_hook['postbit_controls'] .= $templater->render();
	}
}

if (is_array(THANKS::$created['statistics']))
{
	$post = array_merge($post, THANKS::$created['statistics']);
}

$thanks_postbit = '';

if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/thanks/includes/class_template.php');
}

if (intval($this->registry->versionnumber) == 3)
{
	global $vbcollapse;
	
	$post['thankspostid'] = 'thankspostmenu_' . $post['postid'] . '_table';
	$post['thankspostimgid'] = 'collapseimg_' . $post['thankspostid'];
	$post['thankscollapseobj'] = $vbcollapse["collapseobj_{$post[thankspostid]}"];
	$post['thankscollapseimg'] = $vbcollapse["collapseimg_{$post[thankspostid]}"];
}

$thanks_postbit_stats = '';
foreach (THANKS::$cache['button'] as $button)
{
	if (!$button['active'] OR ((int)$post['dbtech_thanks_settings'] & (int)$button['bitfield']))
	{
		// Inactive button
		continue;
	}
	
	if (!isset($post[$button['varname'] . '_given']) AND $post['userid'] AND !$hasInserted)
	{
		// Broken record
		$this->registry->db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "dbtech_thanks_statistics
				(userid)
			VALUES (
				" . intval($post['userid']) . "
			)
		");
		
		// Ensure we don't try to mass insert
		$hasInserted = true;
	}
	
	$templater = vB_Template::create('dbtech_thanks_postbit_stats');
		$templater->register('title', $button['title'] . ' (' . $vbphrase['dbtech_thanks_given'] . ')');
		$templater->register('stat', $post[$button['varname'] . '_given']);
	$thanks_postbit_stats .= $templater->render();
		
	$templater = vB_Template::create('dbtech_thanks_postbit_stats');
		$templater->register('title', $button['title'] . ' (' . $vbphrase['dbtech_thanks_received'] . ')');
		$templater->register('stat', $post[$button['varname'] . '_received']);
	$thanks_postbit_stats .= $templater->render();	
}

$templater = vB_Template::create('dbtech_thanks_postbit');
	$templater->register('stylevar', 	$stylevar);
	$templater->register('post', 		$post);
	$templater->register('stats', 		$thanks_postbit_stats);
$thanks_postbit .= $templater->render();	

if (!$this->registry->options['dbtech_thanks_postbit_deployment'])
{
	// Automatic deployment
	$template_hook['postbit_userinfo_right_after_posts'] .= $thanks_postbit;	
}

if (intval($this->registry->versionnumber) > 3)
{
	vB_Template::preRegister('postbit', array('thanks_postbit' => $thanks_postbit));
	vB_Template::preRegister('postbit_legacy', array('thanks_postbit' => $thanks_postbit));
}

if (class_exists('POSTBITTABS'))
{
	if (!POSTBITTABS::$created['dbtech_thanks'])
	{
		// DragonByte Tech: Postbit Tabs - registerView()
		POSTBITTABS::registerView('dbtech_thanks_stats', 'DragonByte Tech: Advanced Post Thanks / Like - Thanks Stats', (intval($this->registry->versionnumber) == 3 ? '{$thanks_postbit}' : '<dl>{vb:raw thanks_postbit}</dl>'));
		
		// Set created
		POSTBITTABS::$created['dbtech_thanks'] = true;
	}
}

if ((THIS_SCRIPT == 'showthread' OR THIS_SCRIPT == 'showpost') AND ($this->registry->userinfo['userid'] OR !$this->registry->options['dbtech_thanks_hideguests']))
{
	$noticeforuminfo = $this->registry->forumcache["$thread[forumid]"];
	if (!THANKS::$isPro)
	{
		// Lite-only shit
		$parentlist = explode(',', $noticeforuminfo['parentlist']);
		if ($parentlist[0] == -1)
		{
			// This forum
			$noticeforum = $noticeforuminfo['forumid'];		
		}
		else
		{
			$key = (count($parentlist) - 2);
			$noticeforum = $parentlist["$key"];
		}
	}
	else
	{
		// This forum
		$noticeforum = $noticeforuminfo['forumid'];
	}
	
	$excluded = array();
	foreach (THANKS::$cache['button'] as $button)
	{
		if (THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data_full']["{$this->registry->userinfo[userid]}"] AND $button['exclusivity'])
		{
			foreach (THANKS::$cache['button'] as $excludebutton)
			{
				if ((int)$button['exclusivity'] & (int)$excludebutton['bitfield'])
				{
					// This button is exclusive
					$excluded[] = $excludebutton['varname'];
				}
			}
		}
	}
	
	if ($post['userid'] != $this->registry->userinfo['userid'] OR THANKS::$entrycache["$post[postid]"])
	{
		$entries = '';
		$actions = '';
		foreach (THANKS::$cache['button'] as $button)
		{
			if (!$button['active'])
			{
				// Inactive button
				continue;
			}
			
			if (!empty(THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data']))
			{
				$templater = vB_Template::create('dbtech_thanks_postbit_entries_entrybit');
					$templater->register('post', $post);		
					$templater->register('button', $button);
					$templater->register('users', implode(', ', (array)THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data']));
					$templater->register('otherusers', implode(', ', (array)THANKS::$entrycache["$post[postid]"]["$button[varname]"]['totals']));
				$entries .= $templater->render();
			}
			
			/*
				Note for Deceptor or Darkwaltz4 if they find their way in here:
				I made these if checks separate because it makes debugging easier should one of these checks fail.
				Before, I had to var_dump() different parts of the ridiculously huge if check to find out which failed.
				
				Get off my internets. I don't care about sexy code, I care about easily debuggable code.
				K
				THX
				BAI
				
				- Belazor
			*/
			if ((int)$this->registry->forumcache["$noticeforum"]['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
			{
				// Button was disabled for this forum
				continue;
			}
			
			if ((int)$thread['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
			{
				// Button was disabled for this thread
				continue;
			}
			
			if ((int)$post['dbtech_thanks_disabledbuttons'] & (int)$button['bitfield'])
			{
				// Button was disabled for this post
				continue;
			}
			
			if ($post['userid'] == $this->registry->userinfo['userid'])
			{
				// Can't click yo own shit son
				continue;
			}
			
			if (!THANKS::check_permissions($this->registry->userinfo, $button['permissions'], 'canclick'))
			{
				// We can't click this button
				continue;
			}
			
			if (THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data_full']["{$this->registry->userinfo[userid]}"] AND (!THANKS::check_permissions($this->registry->userinfo, $button['permissions'], 'canunclick') OR !THANKS::$isPro))
			{
				// We can't un-click this button
				continue;
			}
			
			if (in_array($button['varname'], $excluded))
			{
				// We clicked another button that prevented this button click
				continue;
			}
			
			$templater = vB_Template::create('dbtech_thanks_postbit_entries_actionbit');
				$templater->register('post', $post);		
				$templater->register('button', $button);
				$templater->register('phrase', (!THANKS::$entrycache["$post[postid]"]["$button[varname]"]['data_full']["{$this->registry->userinfo[userid]}"] ? $button['actiontext'] : $button['undotext']));
			$actions .= $templater->render();
		}
		
		if ($actions)
		{
			$templater = vB_Template::create('dbtech_thanks_postbit_entries_actions');
				$templater->register('post', 	$post);		
				$templater->register('actions', $actions);
			$actions = $templater->render();
		}
		
		// Whether we're showing these areas
		$show['dbtech_thanks_area'] = ($actions OR $entries);
		
		if ($this->registry->options['dbtech_thanks_integratedactions'])
		{
			// Stuff these in the postbit_controls instead
			$template_hook['postbit_controls'] .= $actions;
			$actions = '';
		}
		
		// Ensure this is set
		$this->registry->options['dbtech_thanks_cloud_location'] = ($this->registry->options['dbtech_thanks_cloud_location'] ? $this->registry->options['dbtech_thanks_cloud_location'] : 'postbit_end');
		
		$templater = vB_Template::create('dbtech_thanks_postbit_entries');
			$templater->register('post', 	$post);
			$templater->register('show', 	$show);
			$templater->register('entries', $entries);
			$templater->register('actions', $actions);
		$template_hook["{$this->registry->options[dbtech_thanks_cloud_location]}"] .= $templater->render();
	}
}
?>